/*
 * SH7203 Pinmux
 *
 *  Copyright (C) 2008  Magnus Damm
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 */

#include <linux/kernel.h>
#include <linux/gpio.h>
#include <cpu/sh7203.h>

#include "sh_pfc.h"

enum {
	PINMUX_RESERVED = 0,

	PINMUX_DATA_BEGIN,
	PA7_DATA, PA6_DATA, PA5_DATA, PA4_DATA,
	PA3_DATA, PA2_DATA, PA1_DATA, PA0_DATA,
	PB12_DATA,
	PB11_DATA, PB10_DATA, PB9_DATA, PB8_DATA,
	PB7_DATA, PB6_DATA, PB5_DATA, PB4_DATA,
	PB3_DATA, PB2_DATA, PB1_DATA, PB0_DATA,
	PC14_DATA, PC13_DATA, PC12_DATA,
	PC11_DATA, PC10_DATA, PC9_DATA, PC8_DATA,
	PC7_DATA, PC6_DATA, PC5_DATA, PC4_DATA,
	PC3_DATA, PC2_DATA, PC1_DATA, PC0_DATA,
	PD15_DATA, PD14_DATA, PD13_DATA, PD12_DATA,
	PD11_DATA, PD10_DATA, PD9_DATA, PD8_DATA,
	PD7_DATA, PD6_DATA, PD5_DATA, PD4_DATA,
	PD3_DATA, PD2_DATA, PD1_DATA, PD0_DATA,
	PE15_DATA, PE14_DATA, PE13_DATA, PE12_DATA,
	PE11_DATA, PE10_DATA, PE9_DATA, PE8_DATA,
	PE7_DATA, PE6_DATA, PE5_DATA, PE4_DATA,
	PE3_DATA, PE2_DATA, PE1_DATA, PE0_DATA,
	PF30_DATA, PF29_DATA, PF28_DATA,
	PF27_DATA, PF26_DATA, PF25_DATA, PF24_DATA,
	PF23_DATA, PF22_DATA, PF21_DATA, PF20_DATA,
	PF19_DATA, PF18_DATA, PF17_DATA, PF16_DATA,
	PF15_DATA, PF14_DATA, PF13_DATA, PF12_DATA,
	PF11_DATA, PF10_DATA, PF9_DATA, PF8_DATA,
	PF7_DATA, PF6_DATA, PF5_DATA, PF4_DATA,
	PF3_DATA, PF2_DATA, PF1_DATA, PF0_DATA,
	PINMUX_DATA_END,

	PINMUX_INPUT_BEGIN,
	FORCE_IN,
	PA7_IN, PA6_IN, PA5_IN, PA4_IN,
	PA3_IN, PA2_IN, PA1_IN, PA0_IN,
	PB11_IN, PB10_IN, PB9_IN, PB8_IN,
	PC14_IN, PC13_IN, PC12_IN,
	PC11_IN, PC10_IN, PC9_IN, PC8_IN,
	PC7_IN, PC6_IN, PC5_IN, PC4_IN,
	PC3_IN, PC2_IN, PC1_IN, PC0_IN,
	PD15_IN, PD14_IN, PD13_IN, PD12_IN,
	PD11_IN, PD10_IN, PD9_IN, PD8_IN,
	PD7_IN, PD6_IN, PD5_IN, PD4_IN,
	PD3_IN, PD2_IN, PD1_IN, PD0_IN,
	PE15_IN, PE14_IN, PE13_IN, PE12_IN,
	PE11_IN, PE10_IN, PE9_IN, PE8_IN,
	PE7_IN, PE6_IN, PE5_IN, PE4_IN,
	PE3_IN, PE2_IN, PE1_IN, PE0_IN,
	PF30_IN, PF29_IN, PF28_IN,
	PF27_IN, PF26_IN, PF25_IN, PF24_IN,
	PF23_IN, PF22_IN, PF21_IN, PF20_IN,
	PF19_IN, PF18_IN, PF17_IN, PF16_IN,
	PF15_IN, PF14_IN, PF13_IN, PF12_IN,
	PF11_IN, PF10_IN, PF9_IN, PF8_IN,
	PF7_IN, PF6_IN, PF5_IN, PF4_IN,
	PF3_IN, PF2_IN, PF1_IN, PF0_IN,
	PINMUX_INPUT_END,

	PINMUX_OUTPUT_BEGIN,
	FORCE_OUT,
	PB11_OUT, PB10_OUT, PB9_OUT, PB8_OUT,
	PC14_OUT, PC13_OUT, PC12_OUT,
	PC11_OUT, PC10_OUT, PC9_OUT, PC8_OUT,
	PC7_OUT, PC6_OUT, PC5_OUT, PC4_OUT,
	PC3_OUT, PC2_OUT, PC1_OUT, PC0_OUT,
	PD15_OUT, PD14_OUT, PD13_OUT, PD12_OUT,
	PD11_OUT, PD10_OUT, PD9_OUT, PD8_OUT,
	PD7_OUT, PD6_OUT, PD5_OUT, PD4_OUT,
	PD3_OUT, PD2_OUT, PD1_OUT, PD0_OUT,
	PE15_OUT, PE14_OUT, PE13_OUT, PE12_OUT,
	PE11_OUT, PE10_OUT, PE9_OUT, PE8_OUT,
	PE7_OUT, PE6_OUT, PE5_OUT, PE4_OUT,
	PE3_OUT, PE2_OUT, PE1_OUT, PE0_OUT,
	PF30_OUT, PF29_OUT, PF28_OUT,
	PF27_OUT, PF26_OUT, PF25_OUT, PF24_OUT,
	PF23_OUT, PF22_OUT, PF21_OUT, PF20_OUT,
	PF19_OUT, PF18_OUT, PF17_OUT, PF16_OUT,
	PF15_OUT, PF14_OUT, PF13_OUT, PF12_OUT,
	PF11_OUT, PF10_OUT, PF9_OUT, PF8_OUT,
	PF7_OUT, PF6_OUT, PF5_OUT, PF4_OUT,
	PF3_OUT, PF2_OUT, PF1_OUT, PF0_OUT,
	PINMUX_OUTPUT_END,

	PINMUX_FUNCTION_BEGIN,
	PB11_IOR_IN, PB11_IOR_OUT,
	PB10_IOR_IN, PB10_IOR_OUT,
	PB9_IOR_IN, PB9_IOR_OUT,
	PB8_IOR_IN, PB8_IOR_OUT,
	PB12MD_00, PB12MD_01, PB12MD_10, PB12MD_11,
	PB11MD_0, PB11MD_1,
	PB10MD_0, PB10MD_1,
	PB9MD_00, PB9MD_01, PB9MD_10,
	PB8MD_00, PB8MD_01, PB8MD_10,
	PB7MD_00, PB7MD_01, PB7MD_10, PB7MD_11,
	PB6MD_00, PB6MD_01, PB6MD_10, PB6MD_11,
	PB5MD_00, PB5MD_01, PB5MD_10, PB5MD_11,
	PB4MD_00, PB4MD_01, PB4MD_10, PB4MD_11,
	PB3MD_00, PB3MD_01, PB3MD_10, PB3MD_11,
	PB2MD_00, PB2MD_01, PB2MD_10, PB2MD_11,
	PB1MD_00, PB1MD_01, PB1MD_10, PB1MD_11,
	PB0MD_00, PB0MD_01, PB0MD_10, PB0MD_11,

	PB12IRQ_00, PB12IRQ_01, PB12IRQ_10,

	PC14MD_0, PC14MD_1,
	PC13MD_0, PC13MD_1,
	PC12MD_0, PC12MD_1,
	PC11MD_00, PC11MD_01, PC11MD_10,
	PC10MD_00, PC10MD_01, PC10MD_10,
	PC9MD_0, PC9MD_1,
	PC8MD_0, PC8MD_1,
	PC7MD_0, PC7MD_1,
	PC6MD_0, PC6MD_1,
	PC5MD_0, PC5MD_1,
	PC4MD_0, PC4MD_1,
	PC3MD_0, PC3MD_1,
	PC2MD_0, PC2MD_1,
	PC1MD_0, PC1MD_1,
	PC0MD_00, PC0MD_01, PC0MD_10,

	PD15MD_000, PD15MD_001, PD15MD_010, PD15MD_100, PD15MD_101,
	PD14MD_000, PD14MD_001, PD14MD_010, PD14MD_101,
	PD13MD_000, PD13MD_001, PD13MD_010, PD13MD_100, PD13MD_101,
	PD12MD_000, PD12MD_001, PD12MD_010, PD12MD_100, PD12MD_101,
	PD11MD_000, PD11MD_001, PD11MD_010, PD11MD_100, PD11MD_101,
	PD10MD_000, PD10MD_001, PD10MD_010, PD10MD_100, PD10MD_101,
	PD9MD_000, PD9MD_001, PD9MD_010, PD9MD_100, PD9MD_101,
	PD8MD_000, PD8MD_001, PD8MD_010, PD8MD_100, PD8MD_101,
	PD7MD_000, PD7MD_001, PD7MD_010, PD7MD_011, PD7MD_100, PD7MD_101,
	PD6MD_000, PD6MD_001, PD6MD_010, PD6MD_011, PD6MD_100, PD6MD_101,
	PD5MD_000, PD5MD_001, PD5MD_010, PD5MD_011, PD5MD_100, PD5MD_101,
	PD4MD_000, PD4MD_001, PD4MD_010, PD4MD_011, PD4MD_100, PD4MD_101,
	PD3MD_000, PD3MD_001, PD3MD_010, PD3MD_011, PD3MD_100, PD3MD_101,
	PD2MD_000, PD2MD_001, PD2MD_010, PD2MD_011, PD2MD_100, PD2MD_101,
	PD1MD_000, PD1MD_001, PD1MD_010, PD1MD_011, PD1MD_100, PD1MD_101,
	PD0MD_000, PD0MD_001, PD0MD_010, PD0MD_011, PD0MD_100, PD0MD_101,

	PE15MD_00, PE15MD_01, PE15MD_11,
	PE14MD_00, PE14MD_01, PE14MD_11,
	PE13MD_00, PE13MD_11,
	PE12MD_00, PE12MD_11,
	PE11MD_000, PE11MD_001, PE11MD_010, PE11MD_100,
	PE10MD_000, PE10MD_001, PE10MD_010, PE10MD_100,
	PE9MD_00, PE9MD_01, PE9MD_10, PE9MD_11,
	PE8MD_00, PE8MD_01, PE8MD_10, PE8MD_11,
	PE7MD_000, PE7MD_001, PE7MD_010, PE7MD_011, PE7MD_100,
	PE6MD_000, PE6MD_001, PE6MD_010, PE6MD_011, PE6MD_100,
	PE5MD_000, PE5MD_001, PE5MD_010, PE5MD_011, PE5MD_100,
	PE4MD_000, PE4MD_001, PE4MD_010, PE4MD_011, PE4MD_100,
	PE3MD_00, PE3MD_01, PE3MD_11,
	PE2MD_00, PE2MD_01, PE2MD_11,
	PE1MD_00, PE1MD_01, PE1MD_10, PE1MD_11,
	PE0MD_000, PE0MD_001, PE0MD_011, PE0MD_100,

	PF30MD_0, PF30MD_1,
	PF29MD_0, PF29MD_1,
	PF28MD_0, PF28MD_1,
	PF27MD_0, PF27MD_1,
	PF26MD_0, PF26MD_1,
	PF25MD_0, PF25MD_1,
	PF24MD_0, PF24MD_1,
	PF23MD_00, PF23MD_01, PF23MD_10,
	PF22MD_00, PF22MD_01, PF22MD_10,
	PF21MD_00, PF21MD_01, PF21MD_10,
	PF20MD_00, PF20MD_01, PF20MD_10,
	PF19MD_00, PF19MD_01, PF19MD_10,
	PF18MD_00, PF18MD_01, PF18MD_10,
	PF17MD_00, PF17MD_01, PF17MD_10,
	PF16MD_00, PF16MD_01, PF16MD_10,
	PF15MD_00, PF15MD_01, PF15MD_10,
	PF14MD_00, PF14MD_01, PF14MD_10,
	PF13MD_00, PF13MD_01, PF13MD_10,
	PF12MD_00, PF12MD_01, PF12MD_10,
	PF11MD_00, PF11MD_01, PF11MD_10,
	PF10MD_00, PF10MD_01, PF10MD_10,
	PF9MD_00, PF9MD_01, PF9MD_10,
	PF8MD_00, PF8MD_01, PF8MD_10,
	PF7MD_00, PF7MD_01, PF7MD_10, PF7MD_11,
	PF6MD_00, PF6MD_01, PF6MD_10, PF6MD_11,
	PF5MD_00, PF5MD_01, PF5MD_10, PF5MD_11,
	PF4MD_00, PF4MD_01, PF4MD_10, PF4MD_11,
	PF3MD_00, PF3MD_01, PF3MD_10, PF3MD_11,
	PF2MD_00, PF2MD_01, PF2MD_10, PF2MD_11,
	PF1MD_00, PF1MD_01, PF1MD_10, PF1MD_11,
	PF0MD_00, PF0MD_01, PF0MD_10, PF0MD_11,
	PINMUX_FUNCTION_END,

	PINMUX_MARK_BEGIN,
	PINT7_PB_MARK, PINT6_PB_MARK, PINT5_PB_MARK, PINT4_PB_MARK,
	PINT3_PB_MARK, PINT2_PB_MARK, PINT1_PB_MARK, PINT0_PB_MARK,
	PINT7_PD_MARK, PINT6_PD_MARK, PINT5_PD_MARK, PINT4_PD_MARK,
	PINT3_PD_MARK, PINT2_PD_MARK, PINT1_PD_MARK, PINT0_PD_MARK,
	IRQ7_PB_MARK, IRQ6_PB_MARK, IRQ5_PB_MARK, IRQ4_PB_MARK,
	IRQ3_PB_MARK, IRQ2_PB_MARK, IRQ1_PB_MARK, IRQ0_PB_MARK,
	IRQ7_PD_MARK, IRQ6_PD_MARK, IRQ5_PD_MARK, IRQ4_PD_MARK,
	IRQ3_PD_MARK, IRQ2_PD_MARK, IRQ1_PD_MARK, IRQ0_PD_MARK,
	IRQ7_PE_MARK, IRQ6_PE_MARK, IRQ5_PE_MARK, IRQ4_PE_MARK,
	IRQ3_PE_MARK, IRQ2_PE_MARK, IRQ1_PE_MARK, IRQ0_PE_MARK,
	WDTOVF_MARK, IRQOUT_MARK, REFOUT_MARK, IRQOUT_REFOUT_MARK,
	UBCTRG_MARK,
	CTX1_MARK, CRX1_MARK, CTX0_MARK, CTX0_CTX1_MARK,
	CRX0_MARK, CRX0_CRX1_MARK,
	SDA3_MARK, SCL3_MARK,
	SDA2_MARK, SCL2_MARK,
	SDA1_MARK, SCL1_MARK,
	SDA0_MARK, SCL0_MARK,
	TEND0_PD_MARK, TEND0_PE_MARK, DACK0_PD_MARK, DACK0_PE_MARK,
	DREQ0_PD_MARK, DREQ0_PE_MARK, TEND1_PD_MARK, TEND1_PE_MARK,
	DACK1_PD_MARK, DACK1_PE_MARK, DREQ1_PD_MARK, DREQ1_PE_MARK,
	DACK2_MARK, DREQ2_MARK, DACK3_MARK, DREQ3_MARK,
	ADTRG_PD_MARK, ADTRG_PE_MARK,
	D31_MARK, D30_MARK, D29_MARK, D28_MARK,
	D27_MARK, D26_MARK, D25_MARK, D24_MARK,
	D23_MARK, D22_MARK, D21_MARK, D20_MARK,
	D19_MARK, D18_MARK, D17_MARK, D16_MARK,
	A25_MARK, A24_MARK, A23_MARK, A22_MARK,
	A21_MARK, CS4_MARK, MRES_MARK, BS_MARK,
	IOIS16_MARK, CS1_MARK, CS6_CE1B_MARK, CE2B_MARK,
	CS5_CE1A_MARK, CE2A_MARK, FRAME_MARK, WAIT_MARK,
	RDWR_MARK, CKE_MARK, CASU_MARK,	BREQ_MARK,
	RASU_MARK, BACK_MARK, CASL_MARK, RASL_MARK,
	WE3_DQMUU_AH_ICIO_WR_MARK, WE2_DQMUL_ICIORD_MARK,
	WE1_DQMLU_WE_MARK, WE0_DQMLL_MARK,
	CS3_MARK, CS2_MARK, A1_MARK, A0_MARK, CS7_MARK,
	TIOC4D_MARK, TIOC4C_MARK, TIOC4B_MARK, TIOC4A_MARK,
	TIOC3D_MARK, TIOC3C_MARK, TIOC3B_MARK, TIOC3A_MARK,
	TIOC2B_MARK, TIOC1B_MARK, TIOC2A_MARK, TIOC1A_MARK,
	TIOC0D_MARK, TIOC0C_MARK, TIOC0B_MARK, TIOC0A_MARK,
	TCLKD_PD_MARK, TCLKC_PD_MARK, TCLKB_PD_MARK, TCLKA_PD_MARK,
	TCLKD_PF_MARK, TCLKC_PF_MARK, TCLKB_PF_MARK, TCLKA_PF_MARK,
	SCS0_PD_MARK, SSO0_PD_MARK, SSI0_PD_MARK, SSCK0_PD_MARK,
	SCS0_PF_MARK, SSO0_PF_MARK, SSI0_PF_MARK, SSCK0_PF_MARK,
	SCS1_PD_MARK, SSO1_PD_MARK, SSI1_PD_MARK, SSCK1_PD_MARK,
	SCS1_PF_MARK, SSO1_PF_MARK, SSI1_PF_MARK, SSCK1_PF_MARK,
	TXD0_MARK, RXD0_MARK, SCK0_MARK,
	TXD1_MARK, RXD1_MARK, SCK1_MARK,
	TXD2_MARK, RXD2_MARK, SCK2_MARK,
	RTS3_MARK, CTS3_MARK, TXD3_MARK,
	RXD3_MARK, SCK3_MARK,
	AUDIO_CLK_MARK,
	SSIDATA3_MARK, SSIWS3_MARK, SSISCK3_MARK,
	SSIDATA2_MARK, SSIWS2_MARK, SSISCK2_MARK,
	SSIDATA1_MARK, SSIWS1_MARK, SSISCK1_MARK,
	SSIDATA0_MARK, SSIWS0_MARK, SSISCK0_MARK,
	FCE_MARK, FRB_MARK,
	NAF7_MARK, NAF6_MARK, NAF5_MARK, NAF4_MARK,
	NAF3_MARK, NAF2_MARK, NAF1_MARK, NAF0_MARK,
	FSC_MARK, FOE_MARK, FCDE_MARK, FWE_MARK,
	LCD_VEPWC_MARK, LCD_VCPWC_MARK,	LCD_CLK_MARK, LCD_FLM_MARK,
	LCD_M_DISP_MARK, LCD_CL2_MARK, LCD_CL1_MARK, LCD_DON_MARK,
	LCD_DATA15_MARK, LCD_DATA14_MARK, LCD_DATA13_MARK, LCD_DATA12_MARK,
	LCD_DATA11_MARK, LCD_DATA10_MARK, LCD_DATA9_MARK, LCD_DATA8_MARK,
	LCD_DATA7_MARK, LCD_DATA6_MARK, LCD_DATA5_MARK, LCD_DATA4_MARK,
	LCD_DATA3_MARK, LCD_DATA2_MARK, LCD_DATA1_MARK, LCD_DATA0_MARK,
	PINMUX_MARK_END,
};

static const u16 pinmux_data[] = {
	/* PA */
	PINMUX_DATA(PA7_DATA, PA7_IN),
	PINMUX_DATA(PA6_DATA, PA6_IN),
	PINMUX_DATA(PA5_DATA, PA5_IN),
	PINMUX_DATA(PA4_DATA, PA4_IN),
	PINMUX_DATA(PA3_DATA, PA3_IN),
	PINMUX_DATA(PA2_DATA, PA2_IN),
	PINMUX_DATA(PA1_DATA, PA1_IN),
	PINMUX_DATA(PA0_DATA, PA0_IN),

	/* PB */
	PINMUX_DATA(PB12_DATA, PB12MD_00, FORCE_OUT),
	PINMUX_DATA(WDTOVF_MARK, PB12MD_01),
	PINMUX_DATA(IRQOUT_MARK, PB12MD_10, PB12IRQ_00),
	PINMUX_DATA(REFOUT_MARK, PB12MD_10, PB12IRQ_01),
	PINMUX_DATA(IRQOUT_REFOUT_MARK, PB12MD_10, PB12IRQ_10),
	PINMUX_DATA(UBCTRG_MARK, PB12MD_11),

	PINMUX_DATA(PB11_DATA, PB11MD_0, PB11_IN, PB11_OUT),
	PINMUX_DATA(CTX1_MARK, PB11MD_1),

	PINMUX_DATA(PB10_DATA, PB10MD_0, PB10_IN, PB10_OUT),
	PINMUX_DATA(CRX1_MARK, PB10MD_1),

	PINMUX_DATA(PB9_DATA, PB9MD_00, PB9_IN, PB9_OUT),
	PINMUX_DATA(CTX0_MARK, PB9MD_01),
	PINMUX_DATA(CTX0_CTX1_MARK, PB9MD_10),

	PINMUX_DATA(PB8_DATA, PB8MD_00, PB8_IN, PB8_OUT),
	PINMUX_DATA(CRX0_MARK, PB8MD_01),
	PINMUX_DATA(CRX0_CRX1_MARK, PB8MD_10),

	PINMUX_DATA(PB7_DATA, PB7MD_00, FORCE_IN),
	PINMUX_DATA(SDA3_MARK, PB7MD_01),
	PINMUX_DATA(PINT7_PB_MARK, PB7MD_10),
	PINMUX_DATA(IRQ7_PB_MARK, PB7MD_11),

	PINMUX_DATA(PB6_DATA, PB6MD_00, FORCE_IN),
	PINMUX_DATA(SCL3_MARK, PB6MD_01),
	PINMUX_DATA(PINT6_PB_MARK, PB6MD_10),
	PINMUX_DATA(IRQ6_PB_MARK, PB6MD_11),

	PINMUX_DATA(PB5_DATA, PB5MD_00, FORCE_IN),
	PINMUX_DATA(SDA2_MARK, PB6MD_01),
	PINMUX_DATA(PINT5_PB_MARK, PB6MD_10),
	PINMUX_DATA(IRQ5_PB_MARK, PB6MD_11),

	PINMUX_DATA(PB4_DATA, PB4MD_00, FORCE_IN),
	PINMUX_DATA(SCL2_MARK, PB4MD_01),
	PINMUX_DATA(PINT4_PB_MARK, PB4MD_10),
	PINMUX_DATA(IRQ4_PB_MARK, PB4MD_11),

	PINMUX_DATA(PB3_DATA, PB3MD_00, FORCE_IN),
	PINMUX_DATA(SDA1_MARK, PB3MD_01),
	PINMUX_DATA(PINT3_PB_MARK, PB3MD_10),
	PINMUX_DATA(IRQ3_PB_MARK, PB3MD_11),

	PINMUX_DATA(PB2_DATA, PB2MD_00, FORCE_IN),
	PINMUX_DATA(SCL1_MARK, PB2MD_01),
	PINMUX_DATA(PINT2_PB_MARK, PB2MD_10),
	PINMUX_DATA(IRQ2_PB_MARK, PB2MD_11),

	PINMUX_DATA(PB1_DATA, PB1MD_00, FORCE_IN),
	PINMUX_DATA(SDA0_MARK, PB1MD_01),
	PINMUX_DATA(PINT1_PB_MARK, PB1MD_10),
	PINMUX_DATA(IRQ1_PB_MARK, PB1MD_11),

	PINMUX_DATA(PB0_DATA, PB0MD_00, FORCE_IN),
	PINMUX_DATA(SCL0_MARK, PB0MD_01),
	PINMUX_DATA(PINT0_PB_MARK, PB0MD_10),
	PINMUX_DATA(IRQ0_PB_MARK, PB0MD_11),

	/* PC */
	PINMUX_DATA(PC14_DATA, PC14MD_0, PC14_IN, PC14_OUT),
	PINMUX_DATA(WAIT_MARK, PC14MD_1),

	PINMUX_DATA(PC13_DATA, PC13MD_0, PC13_IN, PC13_OUT),
	PINMUX_DATA(RDWR_MARK, PC13MD_1),

	PINMUX_DATA(PC12_DATA, PC12MD_0, PC12_IN, PC12_OUT),
	PINMUX_DATA(CKE_MARK, PC12MD_1),

	PINMUX_DATA(PC11_DATA, PC11MD_00, PC11_IN, PC11_OUT),
	PINMUX_DATA(CASU_MARK, PC11MD_01),
	PINMUX_DATA(BREQ_MARK, PC11MD_10),

	PINMUX_DATA(PC10_DATA, PC10MD_00, PC10_IN, PC10_OUT),
	PINMUX_DATA(RASU_MARK, PC10MD_01),
	PINMUX_DATA(BACK_MARK, PC10MD_10),

	PINMUX_DATA(PC9_DATA, PC9MD_0, PC9_IN, PC9_OUT),
	PINMUX_DATA(CASL_MARK, PC9MD_1),

	PINMUX_DATA(PC8_DATA, PC8MD_0, PC8_IN, PC8_OUT),
	PINMUX_DATA(RASL_MARK, PC8MD_1),

	PINMUX_DATA(PC7_DATA, PC7MD_0, PC7_IN, PC7_OUT),
	PINMUX_DATA(WE3_DQMUU_AH_ICIO_WR_MARK, PC7MD_1),

	PINMUX_DATA(PC6_DATA, PC6MD_0, PC6_IN, PC6_OUT),
	PINMUX_DATA(WE2_DQMUL_ICIORD_MARK, PC6MD_1),

	PINMUX_DATA(PC5_DATA, PC5MD_0, PC5_IN, PC5_OUT),
	PINMUX_DATA(WE1_DQMLU_WE_MARK, PC5MD_1),

	PINMUX_DATA(PC4_DATA, PC4MD_0, PC4_IN, PC4_OUT),
	PINMUX_DATA(WE0_DQMLL_MARK, PC4MD_1),

	PINMUX_DATA(PC3_DATA, PC3MD_0, PC3_IN, PC3_OUT),
	PINMUX_DATA(CS3_MARK, PC3MD_1),

	PINMUX_DATA(PC2_DATA, PC2MD_0, PC2_IN, PC2_OUT),
	PINMUX_DATA(CS2_MARK, PC2MD_1),

	PINMUX_DATA(PC1_DATA, PC1MD_0, PC1_IN, PC1_OUT),
	PINMUX_DATA(A1_MARK, PC1MD_1),

	PINMUX_DATA(PC0_DATA, PC0MD_00, PC0_IN, PC0_OUT),
	PINMUX_DATA(A0_MARK, PC0MD_01),
	PINMUX_DATA(CS7_MARK, PC0MD_10),

	/* PD */
	PINMUX_DATA(PD15_DATA, PD15MD_000, PD15_IN, PD15_OUT),
	PINMUX_DATA(D31_MARK, PD15MD_001),
	PINMUX_DATA(PINT7_PD_MARK, PD15MD_010),
	PINMUX_DATA(ADTRG_PD_MARK, PD15MD_100),
	PINMUX_DATA(TIOC4D_MARK, PD15MD_101),

	PINMUX_DATA(PD14_DATA, PD14MD_000, PD14_IN, PD14_OUT),
	PINMUX_DATA(D30_MARK, PD14MD_001),
	PINMUX_DATA(PINT6_PD_MARK, PD14MD_010),
	PINMUX_DATA(TIOC4C_MARK, PD14MD_101),

	PINMUX_DATA(PD13_DATA, PD13MD_000, PD13_IN, PD13_OUT),
	PINMUX_DATA(D29_MARK, PD13MD_001),
	PINMUX_DATA(PINT5_PD_MARK, PD13MD_010),
	PINMUX_DATA(TEND1_PD_MARK, PD13MD_100),
	PINMUX_DATA(TIOC4B_MARK, PD13MD_101),

	PINMUX_DATA(PD12_DATA, PD12MD_000, PD12_IN, PD12_OUT),
	PINMUX_DATA(D28_MARK, PD12MD_001),
	PINMUX_DATA(PINT4_PD_MARK, PD12MD_010),
	PINMUX_DATA(DACK1_PD_MARK, PD12MD_100),
	PINMUX_DATA(TIOC4A_MARK, PD12MD_101),

	PINMUX_DATA(PD11_DATA, PD11MD_000, PD11_IN, PD11_OUT),
	PINMUX_DATA(D27_MARK, PD11MD_001),
	PINMUX_DATA(PINT3_PD_MARK, PD11MD_010),
	PINMUX_DATA(DREQ1_PD_MARK, PD11MD_100),
	PINMUX_DATA(TIOC3D_MARK, PD11MD_101),

	PINMUX_DATA(PD10_DATA, PD10MD_000, PD10_IN, PD10_OUT),
	PINMUX_DATA(D26_MARK, PD10MD_001),
	PINMUX_DATA(PINT2_PD_MARK, PD10MD_010),
	PINMUX_DATA(TEND0_PD_MARK, PD10MD_100),
	PINMUX_DATA(TIOC3C_MARK, PD10MD_101),

	PINMUX_DATA(PD9_DATA, PD9MD_000, PD9_IN, PD9_OUT),
	PINMUX_DATA(D25_MARK, PD9MD_001),
	PINMUX_DATA(PINT1_PD_MARK, PD9MD_010),
	PINMUX_DATA(DACK0_PD_MARK, PD9MD_100),
	PINMUX_DATA(TIOC3B_MARK, PD9MD_101),

	PINMUX_DATA(PD8_DATA, PD8MD_000, PD8_IN, PD8_OUT),
	PINMUX_DATA(D24_MARK, PD8MD_001),
	PINMUX_DATA(PINT0_PD_MARK, PD8MD_010),
	PINMUX_DATA(DREQ0_PD_MARK, PD8MD_100),
	PINMUX_DATA(TIOC3A_MARK, PD8MD_101),

	PINMUX_DATA(PD7_DATA, PD7MD_000, PD7_IN, PD7_OUT),
	PINMUX_DATA(D23_MARK, PD7MD_001),
	PINMUX_DATA(IRQ7_PD_MARK, PD7MD_010),
	PINMUX_DATA(SCS1_PD_MARK, PD7MD_011),
	PINMUX_DATA(TCLKD_PD_MARK, PD7MD_100),
	PINMUX_DATA(TIOC2B_MARK, PD7MD_101),

	PINMUX_DATA(PD6_DATA, PD6MD_000, PD6_IN, PD6_OUT),
	PINMUX_DATA(D22_MARK, PD6MD_001),
	PINMUX_DATA(IRQ6_PD_MARK, PD6MD_010),
	PINMUX_DATA(SSO1_PD_MARK, PD6MD_011),
	PINMUX_DATA(TCLKC_PD_MARK, PD6MD_100),
	PINMUX_DATA(TIOC2A_MARK, PD6MD_101),

	PINMUX_DATA(PD5_DATA, PD5MD_000, PD5_IN, PD5_OUT),
	PINMUX_DATA(D21_MARK, PD5MD_001),
	PINMUX_DATA(IRQ5_PD_MARK, PD5MD_010),
	PINMUX_DATA(SSI1_PD_MARK, PD5MD_011),
	PINMUX_DATA(TCLKB_PD_MARK, PD5MD_100),
	PINMUX_DATA(TIOC1B_MARK, PD5MD_101),

	PINMUX_DATA(PD4_DATA, PD4MD_000, PD4_IN, PD4_OUT),
	PINMUX_DATA(D20_MARK, PD4MD_001),
	PINMUX_DATA(IRQ4_PD_MARK, PD4MD_010),
	PINMUX_DATA(SSCK1_PD_MARK, PD4MD_011),
	PINMUX_DATA(TCLKA_PD_MARK, PD4MD_100),
	PINMUX_DATA(TIOC1A_MARK, PD4MD_101),

	PINMUX_DATA(PD3_DATA, PD3MD_000, PD3_IN, PD3_OUT),
	PINMUX_DATA(D19_MARK, PD3MD_001),
	PINMUX_DATA(IRQ3_PD_MARK, PD3MD_010),
	PINMUX_DATA(SCS0_PD_MARK, PD3MD_011),
	PINMUX_DATA(DACK3_MARK, PD3MD_100),
	PINMUX_DATA(TIOC0D_MARK, PD3MD_101),

	PINMUX_DATA(PD2_DATA, PD2MD_000, PD2_IN, PD2_OUT),
	PINMUX_DATA(D18_MARK, PD2MD_001),
	PINMUX_DATA(IRQ2_PD_MARK, PD2MD_010),
	PINMUX_DATA(SSO0_PD_MARK, PD2MD_011),
	PINMUX_DATA(DREQ3_MARK, PD2MD_100),
	PINMUX_DATA(TIOC0C_MARK, PD2MD_101),

	PINMUX_DATA(PD1_DATA, PD1MD_000, PD1_IN, PD1_OUT),
	PINMUX_DATA(D17_MARK, PD1MD_001),
	PINMUX_DATA(IRQ1_PD_MARK, PD1MD_010),
	PINMUX_DATA(SSI0_PD_MARK, PD1MD_011),
	PINMUX_DATA(DACK2_MARK, PD1MD_100),
	PINMUX_DATA(TIOC0B_MARK, PD1MD_101),

	PINMUX_DATA(PD0_DATA, PD0MD_000, PD0_IN, PD0_OUT),
	PINMUX_DATA(D16_MARK, PD0MD_001),
	PINMUX_DATA(IRQ0_PD_MARK, PD0MD_010),
	PINMUX_DATA(SSCK0_PD_MARK, PD0MD_011),
	PINMUX_DATA(DREQ2_MARK, PD0MD_100),
	PINMUX_DATA(TIOC0A_MARK, PD0MD_101),

	/* PE */
	PINMUX_DATA(PE15_DATA, PE15MD_00, PE15_IN, PE15_OUT),
	PINMUX_DATA(IOIS16_MARK, PE15MD_01),
	PINMUX_DATA(RTS3_MARK, PE15MD_11),

	PINMUX_DATA(PE14_DATA, PE14MD_00, PE14_IN, PE14_OUT),
	PINMUX_DATA(CS1_MARK, PE14MD_01),
	PINMUX_DATA(CTS3_MARK, PE14MD_11),

	PINMUX_DATA(PE13_DATA, PE13MD_00, PE13_IN, PE13_OUT),
	PINMUX_DATA(TXD3_MARK, PE13MD_11),

	PINMUX_DATA(PE12_DATA, PE12MD_00, PE12_IN, PE12_OUT),
	PINMUX_DATA(RXD3_MARK, PE12MD_11),

	PINMUX_DATA(PE11_DATA, PE11MD_000, PE11_IN, PE11_OUT),
	PINMUX_DATA(CS6_CE1B_MARK, PE11MD_001),
	PINMUX_DATA(IRQ7_PE_MARK, PE11MD_010),
	PINMUX_DATA(TEND1_PE_MARK, PE11MD_100),

	PINMUX_DATA(PE10_DATA, PE10MD_000, PE10_IN, PE10_OUT),
	PINMUX_DATA(CE2B_MARK, PE10MD_001),
	PINMUX_DATA(IRQ6_PE_MARK, PE10MD_010),
	PINMUX_DATA(TEND0_PE_MARK, PE10MD_100),

	PINMUX_DATA(PE9_DATA, PE9MD_00, PE9_IN, PE9_OUT),
	PINMUX_DATA(CS5_CE1A_MARK, PE9MD_01),
	PINMUX_DATA(IRQ5_PE_MARK, PE9MD_10),
	PINMUX_DATA(SCK3_MARK, PE9MD_11),

	PINMUX_DATA(PE8_DATA, PE8MD_00, PE8_IN, PE8_OUT),
	PINMUX_DATA(CE2A_MARK, PE8MD_01),
	PINMUX_DATA(IRQ4_PE_MARK, PE8MD_10),
	PINMUX_DATA(SCK2_MARK, PE8MD_11),

	PINMUX_DATA(PE7_DATA, PE7MD_000, PE7_IN, PE7_OUT),
	PINMUX_DATA(FRAME_MARK, PE7MD_001),
	PINMUX_DATA(IRQ3_PE_MARK, PE7MD_010),
	PINMUX_DATA(TXD2_MARK, PE7MD_011),
	PINMUX_DATA(DACK1_PE_MARK, PE7MD_100),

	PINMUX_DATA(PE6_DATA, PE6MD_000, PE6_IN, PE6_OUT),
	PINMUX_DATA(A25_MARK, PE6MD_001),
	PINMUX_DATA(IRQ2_PE_MARK, PE6MD_010),
	PINMUX_DATA(RXD2_MARK, PE6MD_011),
	PINMUX_DATA(DREQ1_PE_MARK, PE6MD_100),

	PINMUX_DATA(PE5_DATA, PE5MD_000, PE5_IN, PE5_OUT),
	PINMUX_DATA(A24_MARK, PE5MD_001),
	PINMUX_DATA(IRQ1_PE_MARK, PE5MD_010),
	PINMUX_DATA(TXD1_MARK, PE5MD_011),
	PINMUX_DATA(DACK0_PE_MARK, PE5MD_100),

	PINMUX_DATA(PE4_DATA, PE4MD_000, PE4_IN, PE4_OUT),
	PINMUX_DATA(A23_MARK, PE4MD_001),
	PINMUX_DATA(IRQ0_PE_MARK, PE4MD_010),
	PINMUX_DATA(RXD1_MARK, PE4MD_011),
	PINMUX_DATA(DREQ0_PE_MARK, PE4MD_100),

	PINMUX_DATA(PE3_DATA, PE3MD_00, PE3_IN, PE3_OUT),
	PINMUX_DATA(A22_MARK, PE3MD_01),
	PINMUX_DATA(SCK1_MARK, PE3MD_11),

	PINMUX_DATA(PE2_DATA, PE2MD_00, PE2_IN, PE2_OUT),
	PINMUX_DATA(A21_MARK, PE2MD_01),
	PINMUX_DATA(SCK0_MARK, PE2MD_11),

	PINMUX_DATA(PE1_DATA, PE1MD_00, PE1_IN, PE1_OUT),
	PINMUX_DATA(CS4_MARK, PE1MD_01),
	PINMUX_DATA(MRES_MARK, PE1MD_10),
	PINMUX_DATA(TXD0_MARK, PE1MD_11),

	PINMUX_DATA(PE0_DATA, PE0MD_000, PE0_IN, PE0_OUT),
	PINMUX_DATA(BS_MARK, PE0MD_001),
	PINMUX_DATA(RXD0_MARK, PE0MD_011),
	PINMUX_DATA(ADTRG_PE_MARK, PE0MD_100),

	/* PF */
	PINMUX_DATA(PF30_DATA, PF30MD_0, PF30_IN, PF30_OUT),
	PINMUX_DATA(AUDIO_CLK_MARK, PF30MD_1),

	PINMUX_DATA(PF29_DATA, PF29MD_0, PF29_IN, PF29_OUT),
	PINMUX_DATA(SSIDATA3_MARK, PF29MD_1),

	PINMUX_DATA(PF28_DATA, PF28MD_0, PF28_IN, PF28_OUT),
	PINMUX_DATA(SSIWS3_MARK, PF28MD_1),

	PINMUX_DATA(PF27_DATA, PF27MD_0, PF27_IN, PF27_OUT),
	PINMUX_DATA(SSISCK3_MARK, PF27MD_1),

	PINMUX_DATA(PF26_DATA, PF26MD_0, PF26_IN, PF26_OUT),
	PINMUX_DATA(SSIDATA2_MARK, PF26MD_1),

	PINMUX_DATA(PF25_DATA, PF25MD_0, PF25_IN, PF25_OUT),
	PINMUX_DATA(SSIWS2_MARK, PF25MD_1),

	PINMUX_DATA(PF24_DATA, PF24MD_0, PF24_IN, PF24_OUT),
	PINMUX_DATA(SSISCK2_MARK, PF24MD_1),

	PINMUX_DATA(PF23_DATA, PF23MD_00, PF23_IN, PF23_OUT),
	PINMUX_DATA(SSIDATA1_MARK, PF23MD_01),
	PINMUX_DATA(LCD_VEPWC_MARK, PF23MD_10),

	PINMUX_DATA(PF22_DATA, PF22MD_00, PF22_IN, PF22_OUT),
	PINMUX_DATA(SSIWS1_MARK, PF22MD_01),
	PINMUX_DATA(LCD_VCPWC_MARK, PF22MD_10),

	PINMUX_DATA(PF21_DATA, PF21MD_00, PF21_IN, PF21_OUT),
	PINMUX_DATA(SSISCK1_MARK, PF21MD_01),
	PINMUX_DATA(LCD_CLK_MARK, PF21MD_10),

	PINMUX_DATA(PF20_DATA, PF20MD_00, PF20_IN, PF20_OUT),
	PINMUX_DATA(SSIDATA0_MARK, PF20MD_01),
	PINMUX_DATA(LCD_FLM_MARK, PF20MD_10),

	PINMUX_DATA(PF19_DATA, PF19MD_00, PF19_IN, PF19_OUT),
	PINMUX_DATA(SSIWS0_MARK, PF19MD_01),
	PINMUX_DATA(LCD_M_DISP_MARK, PF19MD_10),

	PINMUX_DATA(PF18_DATA, PF18MD_00, PF18_IN, PF18_OUT),
	PINMUX_DATA(SSISCK0_MARK, PF18MD_01),
	PINMUX_DATA(LCD_CL2_MARK, PF18MD_10),

	PINMUX_DATA(PF17_DATA, PF17MD_00, PF17_IN, PF17_OUT),
	PINMUX_DATA(FCE_MARK, PF17MD_01),
	PINMUX_DATA(LCD_CL1_MARK, PF17MD_10),

	PINMUX_DATA(PF16_DATA, PF16MD_00, PF16_IN, PF16_OUT),
	PINMUX_DATA(FRB_MARK, PF16MD_01),
	PINMUX_DATA(LCD_DON_MARK, PF16MD_10),

	PINMUX_DATA(PF15_DATA, PF15MD_00, PF15_IN, PF15_OUT),
	PINMUX_DATA(NAF7_MARK, PF15MD_01),
	PINMUX_DATA(LCD_DATA15_MARK, PF15MD_10),

	PINMUX_DATA(PF14_DATA, PF14MD_00, PF14_IN, PF14_OUT),
	PINMUX_DATA(NAF6_MARK, PF14MD_01),
	PINMUX_DATA(LCD_DATA14_MARK, PF14MD_10),

	PINMUX_DATA(PF13_DATA, PF13MD_00, PF13_IN, PF13_OUT),
	PINMUX_DATA(NAF5_MARK, PF13MD_01),
	PINMUX_DATA(LCD_DATA13_MARK, PF13MD_10),

	PINMUX_DATA(PF12_DATA, PF12MD_00, PF12_IN, PF12_OUT),
	PINMUX_DATA(NAF4_MARK, PF12MD_01),
	PINMUX_DATA(LCD_DATA12_MARK, PF12MD_10),

	PINMUX_DATA(PF11_DATA, PF11MD_00, PF11_IN, PF11_OUT),
	PINMUX_DATA(NAF3_MARK, PF11MD_01),
	PINMUX_DATA(LCD_DATA11_MARK, PF11MD_10),

	PINMUX_DATA(PF10_DATA, PF10MD_00, PF10_IN, PF10_OUT),
	PINMUX_DATA(NAF2_MARK, PF10MD_01),
	PINMUX_DATA(LCD_DATA10_MARK, PF10MD_10),

	PINMUX_DATA(PF9_DATA, PF9MD_00, PF9_IN, PF9_OUT),
	PINMUX_DATA(NAF1_MARK, PF9MD_01),
	PINMUX_DATA(LCD_DATA9_MARK, PF9MD_10),

	PINMUX_DATA(PF8_DATA, PF8MD_00, PF8_IN, PF8_OUT),
	PINMUX_DATA(NAF0_MARK, PF8MD_01),
	PINMUX_DATA(LCD_DATA8_MARK, PF8MD_10),

	PINMUX_DATA(PF7_DATA, PF7MD_00, PF7_IN, PF7_OUT),
	PINMUX_DATA(FSC_MARK, PF7MD_01),
	PINMUX_DATA(LCD_DATA7_MARK, PF7MD_10),
	PINMUX_DATA(SCS1_PF_MARK, PF7MD_11),

	PINMUX_DATA(PF6_DATA, PF6MD_00, PF6_IN, PF6_OUT),
	PINMUX_DATA(FOE_MARK, PF6MD_01),
	PINMUX_DATA(LCD_DATA6_MARK, PF6MD_10),
	PINMUX_DATA(SSO1_PF_MARK, PF6MD_11),

	PINMUX_DATA(PF5_DATA, PF5MD_00, PF5_IN, PF5_OUT),
	PINMUX_DATA(FCDE_MARK, PF5MD_01),
	PINMUX_DATA(LCD_DATA5_MARK, PF5MD_10),
	PINMUX_DATA(SSI1_PF_MARK, PF5MD_11),

	PINMUX_DATA(PF4_DATA, PF4MD_00, PF4_IN, PF4_OUT),
	PINMUX_DATA(FWE_MARK, PF4MD_01),
	PINMUX_DATA(LCD_DATA4_MARK, PF4MD_10),
	PINMUX_DATA(SSCK1_PF_MARK, PF4MD_11),

	PINMUX_DATA(PF3_DATA, PF3MD_00, PF3_IN, PF3_OUT),
	PINMUX_DATA(TCLKD_PF_MARK, PF3MD_01),
	PINMUX_DATA(LCD_DATA3_MARK, PF3MD_10),
	PINMUX_DATA(SCS0_PF_MARK, PF3MD_11),

	PINMUX_DATA(PF2_DATA, PF2MD_00, PF2_IN, PF2_OUT),
	PINMUX_DATA(TCLKC_PF_MARK, PF2MD_01),
	PINMUX_DATA(LCD_DATA2_MARK, PF2MD_10),
	PINMUX_DATA(SSO0_PF_MARK, PF2MD_11),

	PINMUX_DATA(PF1_DATA, PF1MD_00, PF1_IN, PF1_OUT),
	PINMUX_DATA(TCLKB_PF_MARK, PF1MD_01),
	PINMUX_DATA(LCD_DATA1_MARK, PF1MD_10),
	PINMUX_DATA(SSI0_PF_MARK, PF1MD_11),

	PINMUX_DATA(PF0_DATA, PF0MD_00, PF0_IN, PF0_OUT),
	PINMUX_DATA(TCLKA_PF_MARK, PF0MD_01),
	PINMUX_DATA(LCD_DATA0_MARK, PF0MD_10),
	PINMUX_DATA(SSCK0_PF_MARK, PF0MD_11),
};

static const struct sh_pfc_pin pinmux_pins[] = {
	/* PA */
	PINMUX_GPIO(PA7),
	PINMUX_GPIO(PA6),
	PINMUX_GPIO(PA5),
	PINMUX_GPIO(PA4),
	PINMUX_GPIO(PA3),
	PINMUX_GPIO(PA2),
	PINMUX_GPIO(PA1),
	PINMUX_GPIO(PA0),

	/* PB */
	PINMUX_GPIO(PB12),
	PINMUX_GPIO(PB11),
	PINMUX_GPIO(PB10),
	PINMUX_GPIO(PB9),
	PINMUX_GPIO(PB8),
	PINMUX_GPIO(PB7),
	PINMUX_GPIO(PB6),
	PINMUX_GPIO(PB5),
	PINMUX_GPIO(PB4),
	PINMUX_GPIO(PB3),
	PINMUX_GPIO(PB2),
	PINMUX_GPIO(PB1),
	PINMUX_GPIO(PB0),

	/* PC */
	PINMUX_GPIO(PC14),
	PINMUX_GPIO(PC13),
	PINMUX_GPIO(PC12),
	PINMUX_GPIO(PC11),
	PINMUX_GPIO(PC10),
	PINMUX_GPIO(PC9),
	PINMUX_GPIO(PC8),
	PINMUX_GPIO(PC7),
	PINMUX_GPIO(PC6),
	PINMUX_GPIO(PC5),
	PINMUX_GPIO(PC4),
	PINMUX_GPIO(PC3),
	PINMUX_GPIO(PC2),
	PINMUX_GPIO(PC1),
	PINMUX_GPIO(PC0),

	/* PD */
	PINMUX_GPIO(PD15),
	PINMUX_GPIO(PD14),
	PINMUX_GPIO(PD13),
	PINMUX_GPIO(PD12),
	PINMUX_GPIO(PD11),
	PINMUX_GPIO(PD10),
	PINMUX_GPIO(PD9),
	PINMUX_GPIO(PD8),
	PINMUX_GPIO(PD7),
	PINMUX_GPIO(PD6),
	PINMUX_GPIO(PD5),
	PINMUX_GPIO(PD4),
	PINMUX_GPIO(PD3),
	PINMUX_GPIO(PD2),
	PINMUX_GPIO(PD1),
	PINMUX_GPIO(PD0),

	/* PE */
	PINMUX_GPIO(PE15),
	PINMUX_GPIO(PE14),
	PINMUX_GPIO(PE13),
	PINMUX_GPIO(PE12),
	PINMUX_GPIO(PE11),
	PINMUX_GPIO(PE10),
	PINMUX_GPIO(PE9),
	PINMUX_GPIO(PE8),
	PINMUX_GPIO(PE7),
	PINMUX_GPIO(PE6),
	PINMUX_GPIO(PE5),
	PINMUX_GPIO(PE4),
	PINMUX_GPIO(PE3),
	PINMUX_GPIO(PE2),
	PINMUX_GPIO(PE1),
	PINMUX_GPIO(PE0),

	/* PF */
	PINMUX_GPIO(PF30),
	PINMUX_GPIO(PF29),
	PINMUX_GPIO(PF28),
	PINMUX_GPIO(PF27),
	PINMUX_GPIO(PF26),
	PINMUX_GPIO(PF25),
	PINMUX_GPIO(PF24),
	PINMUX_GPIO(PF23),
	PINMUX_GPIO(PF22),
	PINMUX_GPIO(PF21),
	PINMUX_GPIO(PF20),
	PINMUX_GPIO(PF19),
	PINMUX_GPIO(PF18),
	PINMUX_GPIO(PF17),
	PINMUX_GPIO(PF16),
	PINMUX_GPIO(PF15),
	PINMUX_GPIO(PF14),
	PINMUX_GPIO(PF13),
	PINMUX_GPIO(PF12),
	PINMUX_GPIO(PF11),
	PINMUX_GPIO(PF10),
	PINMUX_GPIO(PF9),
	PINMUX_GPIO(PF8),
	PINMUX_GPIO(PF7),
	PINMUX_GPIO(PF6),
	PINMUX_GPIO(PF5),
	PINMUX_GPIO(PF4),
	PINMUX_GPIO(PF3),
	PINMUX_GPIO(PF2),
	PINMUX_GPIO(PF1),
	PINMUX_GPIO(PF0),
};

#define PINMUX_FN_BASE	ARRAY_SIZE(pinmux_pins)

static const struct pinmux_func pinmux_func_gpios[] = {
	/* INTC */
	GPIO_FN(PINT7_PB),
	GPIO_FN(PINT6_PB),
	GPIO_FN(PINT5_PB),
	GPIO_FN(PINT4_PB),
	GPIO_FN(PINT3_PB),
	GPIO_FN(PINT2_PB),
	GPIO_FN(PINT1_PB),
	GPIO_FN(PINT0_PB),
	GPIO_FN(PINT7_PD),
	GPIO_FN(PINT6_PD),
	GPIO_FN(PINT5_PD),
	GPIO_FN(PINT4_PD),
	GPIO_FN(PINT3_PD),
	GPIO_FN(PINT2_PD),
	GPIO_FN(PINT1_PD),
	GPIO_FN(PINT0_PD),
	GPIO_FN(IRQ7_PB),
	GPIO_FN(IRQ6_PB),
	GPIO_FN(IRQ5_PB),
	GPIO_FN(IRQ4_PB),
	GPIO_FN(IRQ3_PB),
	GPIO_FN(IRQ2_PB),
	GPIO_FN(IRQ1_PB),
	GPIO_FN(IRQ0_PB),
	GPIO_FN(IRQ7_PD),
	GPIO_FN(IRQ6_PD),
	GPIO_FN(IRQ5_PD),
	GPIO_FN(IRQ4_PD),
	GPIO_FN(IRQ3_PD),
	GPIO_FN(IRQ2_PD),
	GPIO_FN(IRQ1_PD),
	GPIO_FN(IRQ0_PD),
	GPIO_FN(IRQ7_PE),
	GPIO_FN(IRQ6_PE),
	GPIO_FN(IRQ5_PE),
	GPIO_FN(IRQ4_PE),
	GPIO_FN(IRQ3_PE),
	GPIO_FN(IRQ2_PE),
	GPIO_FN(IRQ1_PE),
	GPIO_FN(IRQ0_PE),

	GPIO_FN(WDTOVF),
	GPIO_FN(IRQOUT),
	GPIO_FN(REFOUT),
	GPIO_FN(IRQOUT_REFOUT),
	GPIO_FN(UBCTRG),

	/* CAN */
	GPIO_FN(CTX1),
	GPIO_FN(CRX1),
	GPIO_FN(CTX0),
	GPIO_FN(CTX0_CTX1),
	GPIO_FN(CRX0),
	GPIO_FN(CRX0_CRX1),

	/* IIC3 */
	GPIO_FN(SDA3),
	GPIO_FN(SCL3),
	GPIO_FN(SDA2),
	GPIO_FN(SCL2),
	GPIO_FN(SDA1),
	GPIO_FN(SCL1),
	GPIO_FN(SDA0),
	GPIO_FN(SCL0),

	/* DMAC */
	GPIO_FN(TEND0_PD),
	GPIO_FN(TEND0_PE),
	GPIO_FN(DACK0_PD),
	GPIO_FN(DACK0_PE),
	GPIO_FN(DREQ0_PD),
	GPIO_FN(DREQ0_PE),
	GPIO_FN(TEND1_PD),
	GPIO_FN(TEND1_PE),
	GPIO_FN(DACK1_PD),
	GPIO_FN(DACK1_PE),
	GPIO_FN(DREQ1_PD),
	GPIO_FN(DREQ1_PE),
	GPIO_FN(DACK2),
	GPIO_FN(DREQ2),
	GPIO_FN(DACK3),
	GPIO_FN(DREQ3),

	/* ADC */
	GPIO_FN(ADTRG_PD),
	GPIO_FN(ADTRG_PE),

	/* BSC */
	GPIO_FN(D31),
	GPIO_FN(D30),
	GPIO_FN(D29),
	GPIO_FN(D28),
	GPIO_FN(D27),
	GPIO_FN(D26),
	GPIO_FN(D25),
	GPIO_FN(D24),
	GPIO_FN(D23),
	GPIO_FN(D22),
	GPIO_FN(D21),
	GPIO_FN(D20),
	GPIO_FN(D19),
	GPIO_FN(D18),
	GPIO_FN(D17),
	GPIO_FN(D16),
	GPIO_FN(A25),
	GPIO_FN(A24),
	GPIO_FN(A23),
	GPIO_FN(A22),
	GPIO_FN(A21),
	GPIO_FN(CS4),
	GPIO_FN(MRES),
	GPIO_FN(BS),
	GPIO_FN(IOIS16),
	GPIO_FN(CS1),
	GPIO_FN(CS6_CE1B),
	GPIO_FN(CE2B),
	GPIO_FN(CS5_CE1A),
	GPIO_FN(CE2A),
	GPIO_FN(FRAME),
	GPIO_FN(WAIT),
	GPIO_FN(RDWR),
	GPIO_FN(CKE),
	GPIO_FN(CASU),
	GPIO_FN(BREQ),
	GPIO_FN(RASU),
	GPIO_FN(BACK),
	GPIO_FN(CASL),
	GPIO_FN(RASL),
	GPIO_FN(WE3_DQMUU_AH_ICIO_WR),
	GPIO_FN(WE2_DQMUL_ICIORD),
	GPIO_FN(WE1_DQMLU_WE),
	GPIO_FN(WE0_DQMLL),
	GPIO_FN(CS3),
	GPIO_FN(CS2),
	GPIO_FN(A1),
	GPIO_FN(A0),
	GPIO_FN(CS7),

	/* TMU */
	GPIO_FN(TIOC4D),
	GPIO_FN(TIOC4C),
	GPIO_FN(TIOC4B),
	GPIO_FN(TIOC4A),
	GPIO_FN(TIOC3D),
	GPIO_FN(TIOC3C),
	GPIO_FN(TIOC3B),
	GPIO_FN(TIOC3A),
	GPIO_FN(TIOC2B),
	GPIO_FN(TIOC1B),
	GPIO_FN(TIOC2A),
	GPIO_FN(TIOC1A),
	GPIO_FN(TIOC0D),
	GPIO_FN(TIOC0C),
	GPIO_FN(TIOC0B),
	GPIO_FN(TIOC0A),
	GPIO_FN(TCLKD_PD),
	GPIO_FN(TCLKC_PD),
	GPIO_FN(TCLKB_PD),
	GPIO_FN(TCLKA_PD),
	GPIO_FN(TCLKD_PF),
	GPIO_FN(TCLKC_PF),
	GPIO_FN(TCLKB_PF),
	GPIO_FN(TCLKA_PF),

	/* SSU */
	GPIO_FN(SCS0_PD),
	GPIO_FN(SSO0_PD),
	GPIO_FN(SSI0_PD),
	GPIO_FN(SSCK0_PD),
	GPIO_FN(SCS0_PF),
	GPIO_FN(SSO0_PF),
	GPIO_FN(SSI0_PF),
	GPIO_FN(SSCK0_PF),
	GPIO_FN(SCS1_PD),
	GPIO_FN(SSO1_PD),
	GPIO_FN(SSI1_PD),
	GPIO_FN(SSCK1_PD),
	GPIO_FN(SCS1_PF),
	GPIO_FN(SSO1_PF),
	GPIO_FN(SSI1_PF),
	GPIO_FN(SSCK1_PF),

	/* SCIF */
	GPIO_FN(TXD0),
	GPIO_FN(RXD0),
	GPIO_FN(SCK0),
	GPIO_FN(TXD1),
	GPIO_FN(RXD1),
	GPIO_FN(SCK1),
	GPIO_FN(TXD2),
	GPIO_FN(RXD2),
	GPIO_FN(SCK2),
	GPIO_FN(RTS3),
	GPIO_FN(CTS3),
	GPIO_FN(TXD3),
	GPIO_FN(RXD3),
	GPIO_FN(SCK3),

	/* SSI */
	GPIO_FN(AUDIO_CLK),
	GPIO_FN(SSIDATA3),
	GPIO_FN(SSIWS3),
	GPIO_FN(SSISCK3),
	GPIO_FN(SSIDATA2),
	GPIO_FN(SSIWS2),
	GPIO_FN(SSISCK2),
	GPIO_FN(SSIDATA1),
	GPIO_FN(SSIWS1),
	GPIO_FN(SSISCK1),
	GPIO_FN(SSIDATA0),
	GPIO_FN(SSIWS0),
	GPIO_FN(SSISCK0),

	/* FLCTL */
	GPIO_FN(FCE),
	GPIO_FN(FRB),
	GPIO_FN(NAF7),
	GPIO_FN(NAF6),
	GPIO_FN(NAF5),
	GPIO_FN(NAF4),
	GPIO_FN(NAF3),
	GPIO_FN(NAF2),
	GPIO_FN(NAF1),
	GPIO_FN(NAF0),
	GPIO_FN(FSC),
	GPIO_FN(FOE),
	GPIO_FN(FCDE),
	GPIO_FN(FWE),

	/* LCDC */
	GPIO_FN(LCD_VEPWC),
	GPIO_FN(LCD_VCPWC),
	GPIO_FN(LCD_CLK),
	GPIO_FN(LCD_FLM),
	GPIO_FN(LCD_M_DISP),
	GPIO_FN(LCD_CL2),
	GPIO_FN(LCD_CL1),
	GPIO_FN(LCD_DON),
	GPIO_FN(LCD_DATA15),
	GPIO_FN(LCD_DATA14),
	GPIO_FN(LCD_DATA13),
	GPIO_FN(LCD_DATA12),
	GPIO_FN(LCD_DATA11),
	GPIO_FN(LCD_DATA10),
	GPIO_FN(LCD_DATA9),
	GPIO_FN(LCD_DATA8),
	GPIO_FN(LCD_DATA7),
	GPIO_FN(LCD_DATA6),
	GPIO_FN(LCD_DATA5),
	GPIO_FN(LCD_DATA4),
	GPIO_FN(LCD_DATA3),
	GPIO_FN(LCD_DATA2),
	GPIO_FN(LCD_DATA1),
	GPIO_FN(LCD_DATA0),
};

static const struct pinmux_cfg_reg pinmux_config_regs[] = {
	{ PINMUX_CFG_REG("PBIORL", 0xfffe3886, 16, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		PB11_IN, PB11_OUT,
		PB10_IN, PB10_OUT,
		PB9_IN, PB9_OUT,
		PB8_IN, PB8_OUT,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0 }
	},
	{ PINMUX_CFG_REG("PBCRL4", 0xfffe3890, 16, 4) {
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PB12MD_00, PB12MD_01, PB12MD_10, PB12MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PBCRL3", 0xfffe3892, 16, 4) {
		PB11MD_0, PB11MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PB10MD_0, PB10MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PB9MD_00, PB9MD_01, PB9MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PB8MD_00, PB8MD_01, PB8MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PBCRL2", 0xfffe3894, 16, 4) {
		PB7MD_00, PB7MD_01, PB7MD_10, PB7MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PB6MD_00, PB6MD_01, PB6MD_10, PB6MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PB5MD_00, PB5MD_01, PB5MD_10, PB5MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PB4MD_00, PB4MD_01, PB4MD_10, PB4MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PBCRL1", 0xfffe3896, 16, 4) {
		PB3MD_00, PB3MD_01, PB3MD_10, PB3MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PB2MD_00, PB2MD_01, PB2MD_10, PB2MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PB1MD_00, PB1MD_01, PB1MD_10, PB1MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PB0MD_00, PB0MD_01, PB0MD_10, PB0MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("IFCR", 0xfffe38a2, 16, 4) {
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PB12IRQ_00, PB12IRQ_01, PB12IRQ_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PCIORL", 0xfffe3906, 16, 1) {
		0, 0,
		PC14_IN, PC14_OUT,
		PC13_IN, PC13_OUT,
		PC12_IN, PC12_OUT,
		PC11_IN, PC11_OUT,
		PC10_IN, PC10_OUT,
		PC9_IN, PC9_OUT,
		PC8_IN, PC8_OUT,
		PC7_IN, PC7_OUT,
		PC6_IN, PC6_OUT,
		PC5_IN, PC5_OUT,
		PC4_IN, PC4_OUT,
		PC3_IN, PC3_OUT,
		PC2_IN, PC2_OUT,
		PC1_IN, PC1_OUT,
		PC0_IN, PC0_OUT }
	},
	{ PINMUX_CFG_REG("PCCRL4", 0xfffe3910, 16, 4) {
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC14MD_0, PC14MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC13MD_0, PC13MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC12MD_0, PC12MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PCCRL3", 0xfffe3912, 16, 4) {
		PC11MD_00, PC11MD_01, PC11MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC10MD_00, PC10MD_01, PC10MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC9MD_0, PC9MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC8MD_0, PC8MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PCCRL2", 0xfffe3914, 16, 4) {
		PC7MD_0, PC7MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC6MD_0, PC6MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC5MD_0, PC5MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC4MD_0, PC4MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PCCRL1", 0xfffe3916, 16, 4) {
		PC3MD_0, PC3MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC2MD_0, PC2MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC1MD_0, PC1MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC0MD_00, PC0MD_01, PC0MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PDIORL", 0xfffe3986, 16, 1) {
		PD15_IN, PD15_OUT,
		PD14_IN, PD14_OUT,
		PD13_IN, PD13_OUT,
		PD12_IN, PD12_OUT,
		PD11_IN, PD11_OUT,
		PD10_IN, PD10_OUT,
		PD9_IN, PD9_OUT,
		PD8_IN, PD8_OUT,
		PD7_IN, PD7_OUT,
		PD6_IN, PD6_OUT,
		PD5_IN, PD5_OUT,
		PD4_IN, PD4_OUT,
		PD3_IN, PD3_OUT,
		PD2_IN, PD2_OUT,
		PD1_IN, PD1_OUT,
		PD0_IN, PD0_OUT }
	},
	{ PINMUX_CFG_REG("PDCRL4", 0xfffe3990, 16, 4) {
		PD15MD_000, PD15MD_001, PD15MD_010, 0,
		PD15MD_100, PD15MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD14MD_000, PD14MD_001, PD14MD_010, 0,
		0, PD14MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD13MD_000, PD13MD_001, PD13MD_010, 0,
		PD13MD_100, PD13MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD12MD_000, PD12MD_001, PD12MD_010, 0,
		PD12MD_100, PD12MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PDCRL3", 0xfffe3992, 16, 4) {
		PD11MD_000, PD11MD_001, PD11MD_010, 0,
		PD11MD_100, PD11MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD10MD_000, PD10MD_001, PD10MD_010, 0,
		PD10MD_100, PD10MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD9MD_000, PD9MD_001, PD9MD_010, 0,
		PD9MD_100, PD9MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD8MD_000, PD8MD_001, PD8MD_010, 0,
		PD8MD_100, PD8MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PDCRL2", 0xfffe3994, 16, 4) {
		PD7MD_000, PD7MD_001, PD7MD_010, PD7MD_011,
		PD7MD_100, PD7MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD6MD_000, PD6MD_001, PD6MD_010, PD6MD_011,
		PD6MD_100, PD6MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD5MD_000, PD5MD_001, PD5MD_010, PD5MD_011,
		PD5MD_100, PD5MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD4MD_000, PD4MD_001, PD4MD_010, PD4MD_011,
		PD4MD_100, PD4MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PDCRL1", 0xfffe3996, 16, 4) {
		PD3MD_000, PD3MD_001, PD3MD_010, PD3MD_011,
		PD3MD_100, PD3MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD2MD_000, PD2MD_001, PD2MD_010, PD2MD_011,
		PD2MD_100, PD2MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD1MD_000, PD1MD_001, PD1MD_010, PD1MD_011,
		PD1MD_100, PD1MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD0MD_000, PD0MD_001, PD0MD_010, PD0MD_011,
		PD0MD_100, PD0MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PEIORL", 0xfffe3a06, 16, 1) {
		PE15_IN, PE15_OUT,
		PE14_IN, PE14_OUT,
		PE13_IN, PE13_OUT,
		PE12_IN, PE12_OUT,
		PE11_IN, PE11_OUT,
		PE10_IN, PE10_OUT,
		PE9_IN, PE9_OUT,
		PE8_IN, PE8_OUT,
		PE7_IN, PE7_OUT,
		PE6_IN, PE6_OUT,
		PE5_IN, PE5_OUT,
		PE4_IN, PE4_OUT,
		PE3_IN, PE3_OUT,
		PE2_IN, PE2_OUT,
		PE1_IN, PE1_OUT,
		PE0_IN, PE0_OUT }
	},
	{ PINMUX_CFG_REG("PECRL4", 0xfffe3a10, 16, 4) {
		PE15MD_00, PE15MD_01, 0, PE15MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PE14MD_00, PE14MD_01, 0, PE14MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PE13MD_00, 0, 0, PE13MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PE12MD_00, 0, 0, PE12MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PECRL3", 0xfffe3a12, 16, 4) {
		PE11MD_000, PE11MD_001, PE11MD_010, 0,
		PE11MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PE10MD_000, PE10MD_001, PE10MD_010, 0,
		PE10MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PE9MD_00, PE9MD_01, PE9MD_10, PE9MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PE8MD_00, PE8MD_01, PE8MD_10, PE8MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PECRL2", 0xfffe3a14, 16, 4) {
		PE7MD_000, PE7MD_001, PE7MD_010, PE7MD_011,
		PE7MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PE6MD_000, PE6MD_001, PE6MD_010, PE6MD_011,
		PE6MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PE5MD_000, PE5MD_001, PE5MD_010, PE5MD_011,
		PE5MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PE4MD_000, PE4MD_001, PE4MD_010, PE4MD_011,
		PE4MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PECRL1", 0xfffe3a16, 16, 4) {
		PE3MD_00, PE3MD_01, 0, PE3MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PE2MD_00, PE2MD_01, 0, PE2MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PE1MD_00, PE1MD_01, PE1MD_10, PE1MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PE0MD_000, PE0MD_001, 0, PE0MD_011,
		PE0MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PFIORH", 0xfffe3a84, 16, 1) {
		0, 0,
		PF30_IN, PF30_OUT,
		PF29_IN, PF29_OUT,
		PF28_IN, PF28_OUT,
		PF27_IN, PF27_OUT,
		PF26_IN, PF26_OUT,
		PF25_IN, PF25_OUT,
		PF24_IN, PF24_OUT,
		PF23_IN, PF23_OUT,
		PF22_IN, PF22_OUT,
		PF21_IN, PF21_OUT,
		PF20_IN, PF20_OUT,
		PF19_IN, PF19_OUT,
		PF18_IN, PF18_OUT,
		PF17_IN, PF17_OUT,
		PF16_IN, PF16_OUT }
	},
	{ PINMUX_CFG_REG("PFIORL", 0xfffe3a86, 16, 1) {
		PF15_IN, PF15_OUT,
		PF14_IN, PF14_OUT,
		PF13_IN, PF13_OUT,
		PF12_IN, PF12_OUT,
		PF11_IN, PF11_OUT,
		PF10_IN, PF10_OUT,
		PF9_IN, PF9_OUT,
		PF8_IN, PF8_OUT,
		PF7_IN, PF7_OUT,
		PF6_IN, PF6_OUT,
		PF5_IN, PF5_OUT,
		PF4_IN, PF4_OUT,
		PF3_IN, PF3_OUT,
		PF2_IN, PF2_OUT,
		PF1_IN, PF1_OUT,
		PF0_IN, PF0_OUT }
	},
	{ PINMUX_CFG_REG("PFCRH4", 0xfffe3a88, 16, 4) {
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF30MD_0, PF30MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF29MD_0, PF29MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF28MD_0, PF28MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PFCRH3", 0xfffe3a8a, 16, 4) {
		PF27MD_0, PF27MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF26MD_0, PF26MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF25MD_0, PF25MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF24MD_0, PF24MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PFCRH2", 0xfffe3a8c, 16, 4) {
		PF23MD_00, PF23MD_01, PF23MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF22MD_00, PF22MD_01, PF22MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF21MD_00, PF21MD_01, PF21MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF20MD_00, PF20MD_01, PF20MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PFCRH1", 0xfffe3a8e, 16, 4) {
		PF19MD_00, PF19MD_01, PF19MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF18MD_00, PF18MD_01, PF18MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF17MD_00, PF17MD_01, PF17MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF16MD_00, PF16MD_01, PF16MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PFCRL4", 0xfffe3a90, 16, 4) {
		PF15MD_00, PF15MD_01, PF15MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF14MD_00, PF14MD_01, PF14MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF13MD_00, PF13MD_01, PF13MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF12MD_00, PF12MD_01, PF12MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PFCRL3", 0xfffe3a92, 16, 4) {
		PF11MD_00, PF11MD_01, PF11MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF10MD_00, PF10MD_01, PF10MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF9MD_00, PF9MD_01, PF9MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF8MD_00, PF8MD_01, PF8MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PFCRL2", 0xfffe3a94, 16, 4) {
		PF7MD_00, PF7MD_01, PF7MD_10, PF7MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF6MD_00, PF6MD_01, PF6MD_10, PF6MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF5MD_00, PF5MD_01, PF5MD_10, PF5MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF4MD_00, PF4MD_01, PF4MD_10, PF4MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PFCRL1", 0xfffe3a96, 16, 4) {
		PF3MD_00, PF3MD_01, PF3MD_10, PF3MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF2MD_00, PF2MD_01, PF2MD_10, PF2MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF1MD_00, PF1MD_01, PF1MD_10, PF1MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF0MD_00, PF0MD_01, PF0MD_10, PF0MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{}
};

static const struct pinmux_data_reg pinmux_data_regs[] = {
	{ PINMUX_DATA_REG("PADRL", 0xfffe3802, 16) {
		0, 0, 0, 0,
		0, 0, 0, 0,
		PA7_DATA, PA6_DATA, PA5_DATA, PA4_DATA,
		PA3_DATA, PA2_DATA, PA1_DATA, PA0_DATA }
	},
	{ PINMUX_DATA_REG("PBDRL", 0xfffe3882, 16) {
		0, 0, 0, PB12_DATA,
		PB11_DATA, PB10_DATA, PB9_DATA, PB8_DATA,
		PB7_DATA, PB6_DATA, PB5_DATA, PB4_DATA,
		PB3_DATA, PB2_DATA, PB1_DATA, PB0_DATA }
	},
	{ PINMUX_DATA_REG("PCDRL", 0xfffe3902, 16) {
		0, PC14_DATA, PC13_DATA, PC12_DATA,
		PC11_DATA, PC10_DATA, PC9_DATA, PC8_DATA,
		PC7_DATA, PC6_DATA, PC5_DATA, PC4_DATA,
		PC3_DATA, PC2_DATA, PC1_DATA, PC0_DATA }
	},
	{ PINMUX_DATA_REG("PDDRL", 0xfffe3982, 16) {
		PD15_DATA, PD14_DATA, PD13_DATA, PD12_DATA,
		PD11_DATA, PD10_DATA, PD9_DATA, PD8_DATA,
		PD7_DATA, PD6_DATA, PD5_DATA, PD4_DATA,
		PD3_DATA, PD2_DATA, PD1_DATA, PD0_DATA }
	},
	{ PINMUX_DATA_REG("PEDRL", 0xfffe3a02, 16) {
		PE15_DATA, PE14_DATA, PE13_DATA, PE12_DATA,
		PE11_DATA, PE10_DATA, PE9_DATA, PE8_DATA,
		PE7_DATA, PE6_DATA, PE5_DATA, PE4_DATA,
		PE3_DATA, PE2_DATA, PE1_DATA, PE0_DATA }
	},
	{ PINMUX_DATA_REG("PFDRH", 0xfffe3a80, 16) {
		0, PF30_DATA, PF29_DATA, PF28_DATA,
		PF27_DATA, PF26_DATA, PF25_DATA, PF24_DATA,
		PF23_DATA, PF22_DATA, PF21_DATA, PF20_DATA,
		PF19_DATA, PF18_DATA, PF17_DATA, PF16_DATA }
	},
	{ PINMUX_DATA_REG("PFDRL", 0xfffe3a82, 16) {
		PF15_DATA, PF14_DATA, PF13_DATA, PF12_DATA,
		PF11_DATA, PF10_DATA, PF9_DATA, PF8_DATA,
		PF7_DATA, PF6_DATA, PF5_DATA, PF4_DATA,
		PF3_DATA, PF2_DATA, PF1_DATA, PF0_DATA }
	},
	{ },
};

const struct sh_pfc_soc_info sh7203_pinmux_info = {
	.name = "sh7203_pfc",
	.input = { PINMUX_INPUT_BEGIN, PINMUX_INPUT_END, FORCE_IN },
	.output = { PINMUX_OUTPUT_BEGIN, PINMUX_OUTPUT_END, FORCE_OUT },
	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.pins = pinmux_pins,
	.nr_pins = ARRAY_SIZE(pinmux_pins),
	.func_gpios = pinmux_func_gpios,
	.nr_func_gpios = ARRAY_SIZE(pinmux_func_gpios),

	.cfg_regs = pinmux_config_regs,
	.data_regs = pinmux_data_regs,

	.gpio_data = pinmux_data,
	.gpio_data_size = ARRAY_SIZE(pinmux_data),
};
