#ifndef __PPC64_A_OUT_H__
#define __PPC64_A_OUT_H__

#include <asm/ppcdebug.h>

/*
 * c 2001 PPC 64 Team, IBM Corp
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

struct exec
{
	unsigned long a_info;	/* Use macros N_MAGIC, etc for access */
	unsigned a_text;	/* length of text, in bytes */
	unsigned a_data;	/* length of data, in bytes */
	unsigned a_bss;		/* length of uninitialized data area for file, in bytes */
	unsigned a_syms;	/* length of symbol table data in file, in bytes */
	unsigned a_entry;	/* start address */
	unsigned a_trsize;	/* length of relocation info for text, in bytes */
	unsigned a_drsize;	/* length of relocation info for data, in bytes */
};

#define N_TRSIZE(a)	((a).a_trsize)
#define N_DRSIZE(a)	((a).a_drsize)
#define N_SYMSIZE(a)	((a).a_syms)

#ifdef __KERNEL__

/* 64-bit user address space is less PGDIR_SIZE due to pgd_index() bug. */
#define STACK_TOP_USER64 (TASK_SIZE_USER64 - PGDIR_SIZE)

/* Give 32-bit user space a full 4G address space to live in. */
#define STACK_TOP_USER32 (TASK_SIZE_USER32)

#define STACK_TOP ((test_thread_flag(TIF_32BIT) || \
		(ppcdebugset(PPCDBG_BINFMT_32ADDR))) ? \
		STACK_TOP_USER32 : STACK_TOP_USER64)

#endif /* __KERNEL__ */

#endif /* __PPC64_A_OUT_H__ */
