/*
 *  include/asm-s390/current.h
 *
 *  S390 version
 *    Copyright (C) 1999 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *    Author(s): Martin Schwidefsky (schwidefsky@de.ibm.com)
 *
 *  Derived from "include/asm-i386/current.h"
 */

#ifndef _S390_CURRENT_H
#define _S390_CURRENT_H

#ifdef __KERNEL__

struct task_struct;

static inline struct task_struct * get_current(void)
{
        struct task_struct *current;
        __asm__("lghi  %0,-16384\n\t"
                "ngr   %0,15"
                : "=&r" (current) );
        return current;
 }

#define current get_current()

#endif

#endif /* !(_S390_CURRENT_H) */
