#include <stdio.h>
#include <stdarg.h>
#include <syslog.h>
#include "link.h"

char depmod_syslog=0;

void depmod_setsyslog (const char *name)
{
	openlog (name,LOG_CONS,LOG_DAEMON);
	depmod_syslog = 1;
}

/*
	Generate an error message either on stderr or the syslog facility
*/
void depmod_error (const char *ctl, ...)
{
	char buf[1000];
	va_list list;
	va_start (list,ctl);
	vsprintf (buf,ctl,list);
	if (depmod_syslog){
		syslog (LOG_ERR,"%s",buf);
	}else{
		fprintf (stderr,"%s\n",buf);
	}
}

